unit Demof;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Grids, Buttons, AdvEdits;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    neThousandGrouping: TCheckBox;
    Label2: TLabel;
    Label3: TLabel;
    neThousandSeparator: TEdit;
    neDecimalSeparator: TEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    neWholeLen: TEdit;
    neDecimalLen: TEdit;
    GroupBox3: TGroupBox;
    neMinChecking: TCheckBox;
    neMaxChecking: TCheckBox;
    Label6: TLabel;
    neMin: TEdit;
    neMax: TEdit;
    Label7: TLabel;
    GroupBox4: TGroupBox;
    Label1: TLabel;
    Label8: TLabel;
    GroupBox5: TGroupBox;
    neAlignment: TComboBox;
    Label10: TLabel;
    neText: TAdvNumberEdit;
    neBeepOnError: TCheckBox;
    neCanEmpty: TCheckBox;
    GroupBox6: TGroupBox;
    neAutoSelectOnClick: TCheckBox;
    neEnterAsTab: TCheckBox;
    neUpDownAsTab: TCheckBox;
    neFocusColor: TColorBox;
    Label9: TLabel;
    Label12: TLabel;
    neInvertSign: TCheckBox;
    GroupBox7: TGroupBox;
    neFunctionList: TStringGrid;
    neEditorMode: TCheckBox;
    FocusFontDialog: TFontDialog;
    neFocusFont: TBitBtn;
    AddMulList: TBitBtn;
    neValue: TAdvFocusEdit;
    Label11: TLabel;
    nePrecision: TEdit;
    procedure neTextChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure neThousandGroupingClick(Sender: TObject);
    procedure neThousandSeparatorChange(Sender: TObject);
    procedure neDecimalSeparatorChange(Sender: TObject);
    procedure neWholeLenChange(Sender: TObject);
    procedure neDecimalLenChange(Sender: TObject);
    procedure neMinCheckingClick(Sender: TObject);
    procedure neMaxCheckingClick(Sender: TObject);
    procedure neMinChange(Sender: TObject);
    procedure neMaxChange(Sender: TObject);
    procedure neAutoSelectOnClickClick(Sender: TObject);
    procedure neAlignmentChange(Sender: TObject);
    procedure neValueChange(Sender: TObject);
    procedure neBeepOnErrorClick(Sender: TObject);
    procedure neCanEmptyClick(Sender: TObject);
    procedure neEnterAsTabClick(Sender: TObject);
    procedure neUpDownAsTabClick(Sender: TObject);
    procedure neFocusColorChange(Sender: TObject);
    procedure neInvertSignClick(Sender: TObject);
    procedure AddMulListClick(Sender: TObject);
    procedure neFocusFontClick(Sender: TObject);
    procedure neEditorModeClick(Sender: TObject);
    procedure nePrecisionChange(Sender: TObject);
    procedure neTextBoundError(Sender: TObject; MinViolation: Boolean;
      BoundValue: Double);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses FuncListEditor;

{$R *.dfm}
                     
procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.HintHidePause:= 7000;
  with neFunctionList do
  begin
    Cells[0,0]:= 'Shift state'; Cells[1,0]:= 'Key code';
    Cells[2,0]:= 'Opr'; Cells[3,0]:= 'Value';
    Hint:= 'You can use these key combinations to execute the ''Opr'''#13+
      'operation between NumberEdit.Value and specified value'#13+
      'in NumberEdit.FunctionList';
  end;

  neText.FunctionList.Add(MakeItem([],ord('M'),opMul, 1e6));
  neText.FunctionList.Add(MakeItem([],ord('K'),opMul, 1e3));
  FunctionListToGrid(neText.FunctionList, neFunctionList);

  neValue.Text:= FloatToStr(neText.Value);
  neThousandGrouping.Checked:= neText.ThousandGrouping;
  neThousandSeparator.Text:= neText.ThousandSeparator;
  neDecimalSeparator.Text:= neText.DecimalSeparator;

  neWholeLen.Text:= IntToStr(neText.WholeLen);
  neDecimalLen.Text:= IntToStr(neText.DecimalLen);
  nePrecision.Text:= IntToStr(neText.Precision);

  neMinChecking.Checked:= neText.MinChecking;
  neMin.Text:= FloatToStr(neText.Min);
  neMaxChecking.Checked:= neText.MaxChecking;
  neMax.Text:= FloatToStr(neText.Max);

  neAutoSelectOnClick.Checked:= neText.AutoSelectOnClick;
  neEnterAsTab.Checked:= neText.EnterAsTab;
  neUpDownAsTab.Checked:= neText.UpDownAsTab;
  neFocusColor.Selected:= neText.FocusColor;
  FocusFontDialog.Font.Assign(neText.FocusFont);

  neBeepOnError.Checked:= neText.BeepOnError;
  neCanEmpty.Checked:= neText.CanEmpty;
  neInvertSign.Checked:= neText.InvertSign;
  neEditorMode.Checked:= neText.EditorMode;
  neAlignment.ItemIndex:= ord(neText.Alignment);
end;

procedure TForm1.neTextChange(Sender: TObject);
begin
  neValue.Text:= FloatToStr(neText.Value);
end;

procedure TForm1.neValueChange(Sender: TObject);
begin
  try
    neText.Value:= StrToFloat(neValue.Text);
  except
    neValue.Text:= FloatToStr(neText.Value);
  end;
end;

procedure TForm1.neThousandGroupingClick(Sender: TObject);
begin
  neText.ThousandGrouping:= neThousandGrouping.Checked;
end;

procedure TForm1.neThousandSeparatorChange(Sender: TObject);
begin
  if neThousandSeparator.Text <> '' then
    neText.ThousandSeparator:= neThousandSeparator.Text[1];
end;

procedure TForm1.neDecimalSeparatorChange(Sender: TObject);
begin
  if neDecimalSeparator.Text <> '' then
    neText.DecimalSeparator:= neDecimalSeparator.Text[1];
end;

procedure TForm1.neWholeLenChange(Sender: TObject);
begin
  if neWholeLen.Text <> '' then
  try
    neText.WholeLen:= StrToInt(neWholeLen.Text);
  except
    neWholeLen.Text:= IntToStr(neText.WholeLen);
  end;
end;

procedure TForm1.neDecimalLenChange(Sender: TObject);
begin
  if neDecimalLen.Text <> '' then
  try
    neText.DecimalLen:= StrToInt(neDecimalLen.Text);
  except
    neDecimalLen.Text:= IntToStr(neText.DecimalLen);
  end;
end;

procedure TForm1.nePrecisionChange(Sender: TObject);
begin
  if nePrecision.Text <> '' then
  try
    neText.Precision:= StrToInt(nePrecision.Text);
  finally
    nePrecision.Text:= IntToStr(neText.Precision);
  end;
end;

procedure TForm1.neMinCheckingClick(Sender: TObject);
begin
  neText.MinChecking:= neMinChecking.Checked;
end;

procedure TForm1.neMinChange(Sender: TObject);
begin
  if neMin.Text <> '' then
  try
    neText.Min:= StrToFloat(neMin.Text);
  except
  end;
  neMin.Text:= FloatToStr(neText.Min);
end;

procedure TForm1.neMaxCheckingClick(Sender: TObject);
begin
  neText.MaxChecking:= neMaxChecking.Checked;
end;

procedure TForm1.neMaxChange(Sender: TObject);
begin
  if neMax.Text <> '' then
  try
    neText.Max:= StrToFloat(neMax.Text);
  except
  end;
  neMax.Text:= FloatToStr(neText.Max);
end;

procedure TForm1.neAutoSelectOnClickClick(Sender: TObject);
begin
  neText.AutoSelectOnClick:= neAutoSelectOnClick.Checked;
end;

procedure TForm1.neEnterAsTabClick(Sender: TObject);
begin
  neText.EnterAsTab:= neEnterAsTab.Checked;
end;

procedure TForm1.neUpDownAsTabClick(Sender: TObject);
begin
  neText.UpDownAsTab:= neUpDownAsTab.Checked;
end;

procedure TForm1.neFocusColorChange(Sender: TObject);
begin
  neText.FocusColor:= neFocusColor.Selected;
end;

procedure TForm1.neFocusFontClick(Sender: TObject);
begin
  if FocusFontDialog.Execute then
    neText.FocusFont.Assign(FocusFontDialog.Font);
end;

procedure TForm1.neBeepOnErrorClick(Sender: TObject);
begin
  neText.BeepOnError:= neBeepOnError.Checked;
end;

procedure TForm1.neCanEmptyClick(Sender: TObject);
begin
  neText.CanEmpty:= neCanEmpty.Checked;
end;

procedure TForm1.neInvertSignClick(Sender: TObject);
begin
  neText.InvertSign:= neInvertSign.Checked;
end;

procedure TForm1.neEditorModeClick(Sender: TObject);
begin
  neText.EditorMode:= neEditorMode.Checked;
end;

procedure TForm1.neAlignmentChange(Sender: TObject);
begin
  neText.Alignment:= TAlignment(neAlignment.ItemIndex);
end;

procedure TForm1.AddMulListClick(Sender: TObject);
var FunctionListDialog: TFunctionListDialog;
begin
  FunctionListDialog:= TFunctionListDialog.Create(Self);
  try
    FunctionListDialog.FunctionList.Assign(neText.FunctionList);
    if FunctionListDialog.ShowModal = idOk then
    begin
      neText.FunctionList.Assign(FunctionListDialog.FunctionList);
      FunctionListToGrid(FunctionListDialog.FunctionList, neFunctionList);
    end;
  finally
    FunctionListDialog.Free;
  end;
end;

procedure TForm1.neTextBoundError(Sender: TObject; MinViolation: Boolean;
  BoundValue: Double);
begin
  if MinViolation then
    Application.MessageBox(pchar('A megadhat legkisebb szm a(z) '+
      FloatToStr(BoundValue)+'!'),'Hiba',mb_IconStop+mb_Ok)
  else Application.MessageBox(pchar('A megadhat legnagyobb szm a(z) '+
      FloatToStr(BoundValue)+'!'),'Hiba',mb_IconStop+mb_Ok)
end;

end.
