 
{*******************************************************}
{                                                       }
{           Part of NumberEdit component v1.1           }
{                                                       }
{       Copyright (c) 2002 Tams Molnr, Hungary        }
{             e-mail: mot@merkantil.hu                  }
{                                                       }
{  Use it free. Please, send your observations,         }
{  new ideas, changes                                   }
{                                                       }
{*******************************************************}
unit FuncListEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons, AdvEdits;

type
  TFunctionListDialog = class(TForm)
    GroupBox1: TGroupBox;
    FunctionListGrid: TStringGrid;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    nShift: TCheckBox;
    nCtrl: TCheckBox;
    nAlt: TCheckBox;
    nKey: TComboBox;
    nOpr: TComboBox;
    nValue: TAdvNumberEdit;
    NewBtn: TBitBtn;
    DelBtn: TBitBtn;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure nShiftClick(Sender: TObject);
    procedure nValueChange(Sender: TObject);
    procedure NewBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FunctionListGridSelectCell(Sender: TObject; ACol,
      ARow: Integer; var CanSelect: Boolean);
    procedure nKeyChange(Sender: TObject);
    procedure nOprChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    ScrollMode: boolean;
    function CheckItem : boolean;
    procedure RefreshFromGrid(ARow: integer);
  public
    { Public declarations }
    FunctionList: TFunctionList;
  end;

var
  FunctionListDialog: TFunctionListDialog;

procedure FunctionListToGrid(List: TFunctionList; Grid: TStringGrid);

implementation
{$R *.dfm}

const
  VKCodes : array[0..80] of record
    Code: word;
    Name: string;
  end = (
    (Code:VK_BACK     ; Name: 'Backspace'),
    (Code:VK_TAB      ; Name: 'Tab'),
    (Code:VK_RETURN   ; Name: 'Enter'),
    (Code:VK_SPACE    ; Name: 'Space'),
    (Code:VK_PRIOR    ; Name: 'Page Up'),
    (Code:VK_NEXT     ; Name: 'Page Down'),
    (Code:VK_END      ; Name: 'End'),
    (Code:VK_HOME     ; Name: 'Home'),
    (Code:VK_LEFT     ; Name: 'Left Arrow'),
    (Code:VK_UP	      ; Name: 'Up Arrow'),
    (Code:VK_RIGHT    ; Name: 'Right Arrow'),
    (Code:VK_DOWN     ; Name: 'Down Arrow'),
    (Code:VK_INSERT   ; Name: 'Insert'),
    (Code:ord('0')    ; Name: 'Number 0'),
    (Code:ord('1')    ; Name: 'Number 1'),
    (Code:ord('2')    ; Name: 'Number 2'),
    (Code:ord('3')    ; Name: 'Number 3'),
    (Code:ord('4')    ; Name: 'Number 4'),
    (Code:ord('5')    ; Name: 'Number 5'),
    (Code:ord('6')    ; Name: 'Number 6'),
    (Code:ord('7')    ; Name: 'Number 7'),
    (Code:ord('8')    ; Name: 'Number 8'),
    (Code:ord('9')    ; Name: 'Number 9'),
    (Code:ord('A')    ; Name: 'Letter A'),
    (Code:ord('B')    ; Name: 'Letter B'),
    (Code:ord('C')    ; Name: 'Letter C'),
    (Code:ord('D')    ; Name: 'Letter D'),
    (Code:ord('E')    ; Name: 'Letter E'),
    (Code:ord('F')    ; Name: 'Letter F'),
    (Code:ord('G')    ; Name: 'Letter G'),
    (Code:ord('H')    ; Name: 'Letter H'),
    (Code:ord('I')    ; Name: 'Letter I'),
    (Code:ord('J')    ; Name: 'Letter J'),
    (Code:ord('K')    ; Name: 'Letter K'),
    (Code:ord('L')    ; Name: 'Letter L'),
    (Code:ord('M')    ; Name: 'Letter M'),
    (Code:ord('N')    ; Name: 'Letter N'),
    (Code:ord('O')    ; Name: 'Letter O'),
    (Code:ord('P')    ; Name: 'Letter P'),
    (Code:ord('Q')    ; Name: 'Letter Q'),
    (Code:ord('R')    ; Name: 'Letter R'),
    (Code:ord('S')    ; Name: 'Letter S'),
    (Code:ord('T')    ; Name: 'Letter T'),
    (Code:ord('U')    ; Name: 'Letter U'),
    (Code:ord('V')    ; Name: 'Letter V'),
    (Code:ord('W')    ; Name: 'Letter W'),
    (Code:ord('X')    ; Name: 'Letter X'),
    (Code:ord('Y')    ; Name: 'Letter Y'),
    (Code:ord('Z')    ; Name: 'Letter Z'),
    (Code:VK_LWIN     ; Name: 'Left Windows'),
    (Code:VK_RWIN     ; Name: 'Right Windows'),
    (Code:VK_APPS     ; Name: 'Applications key'),
    (Code:VK_CLEAR    ; Name: 'Numeric keypad 5'),
    (Code:VK_MULTIPLY ; Name: 'Numeric keypad *'),
    (Code:VK_ADD      ; Name: 'Numeric keypad +'),
    (Code:VK_SUBTRACT ; Name: 'Numeric keypad -'),
    (Code:VK_DIVIDE   ; Name: 'Numeric keypad /'),
    (Code:VK_F1	      ; Name: 'F1'),
    (Code:VK_F2	      ; Name: 'F2'),
    (Code:VK_F3	      ; Name: 'F3'),
    (Code:VK_F4	      ; Name: 'F4'),
    (Code:VK_F5	      ; Name: 'F5'),
    (Code:VK_F6	      ; Name: 'F6'),
    (Code:VK_F7	      ; Name: 'F7'),
    (Code:VK_F8	      ; Name: 'F8'),
    (Code:VK_F9	      ; Name: 'F9'),
    (Code:VK_F10      ; Name: 'F10'),
    (Code:VK_F11      ; Name: 'F11'),
    (Code:VK_F12      ; Name: 'F12'),
    (Code:VK_F13      ; Name: 'F13'),
    (Code:VK_F14      ; Name: 'F14'),
    (Code:VK_F15      ; Name: 'F15'),
    (Code:VK_F16      ; Name: 'F16'),
    (Code:VK_F17      ; Name: 'F17'),
    (Code:VK_F18      ; Name: 'F18'),
    (Code:VK_F19      ; Name: 'F19'),
    (Code:VK_F20      ; Name: 'F20'),
    (Code:VK_F21      ; Name: 'F21'),
    (Code:VK_F22      ; Name: 'F22'),
    (Code:VK_F23      ; Name: 'F23'),
    (Code:VK_F24      ; Name: 'F24')
  );

procedure TFunctionListDialog.FormCreate(Sender: TObject);
var i: integer;
begin
  with FunctionListGrid do
  begin
    Cells[0,0]:= 'Shift state'; Cells[1,0]:= 'Key code';
    Cells[2,0]:= 'Opr'; Cells[3,0]:= 'Value';
  end;
  FunctionList:= TFunctionList.Create;
  for i:= low(VKCodes) to high(VKCodes) do nKey.Items.Add(VKCodes[i].Name);
end;

procedure TFunctionListDialog.FormDestroy(Sender: TObject);
begin
  FunctionList.Free;
end;

procedure FunctionListToGrid(List: TFunctionList; Grid: TStringGrid);
var
  s: string;
  i,j: integer;
begin
  if List.Count = 0 then
  begin
    Grid.RowCount:= Grid.FixedRows+1;
    for i:= 0 to 2 do Grid.Cells[i,Grid.RowCount-1]:= '';
    Grid.Cells[3,Grid.RowCount-1]:= '0';
  end
  else begin
    Grid.RowCount:= List.Count+1;
    for i:= 0 to List.Count-1 do
    begin
{        if ssShift in PFunctionItem(Items[i])^.Shift then s:= 'Shift, ' else s:= '';
      if ssCtrl in PFunctionItem(Items[i])^.Shift then s:= s+'Ctrl, ';
      if ssAlt in PFunctionItem(Items[i])^.Shift then s:= s+'Alt, ';
      if s <> '' then
      begin SetLength(s,length(s)-2); s:= '['+s+']'; end;}
      Grid.Cells[0,i+1]:= copy(List[i],1,pos(';',List[i])-1);
      j:= high(VKCodes);
      while (j >= 0) and (List.Key[i] <> VKCodes[j].Code) do dec(j);
      if j = -1 then s:= 'Unknown' else s:= VKCodes[j].Name;
      Grid.Cells[1,i+1]:= s;
      Grid.Cells[2,i+1]:= OprStr[ord(List.Operation[i])+1];
      Grid.Cells[3,i+1]:= FloatToStr(List.Value[i]);
    end;
  end;
end;

procedure TFunctionListDialog.FormActivate(Sender: TObject);
var en: boolean;
begin
  en:= FunctionList.Count > 0;
  if en then // fill list
  begin
    FunctionListToGrid(FunctionList, FunctionListGrid);
    RefreshFromGrid(1);
  end;
  FunctionListGrid.Visible:= en; DelBtn.Enabled:= en;
  nShift.Enabled:= en; nCtrl.Enabled:= en; nAlt.Enabled:= en;
  nKey.Enabled:= en; nOpr.Enabled:= en; nValue.Enabled:= en;
  FunctionListGrid.Row:= 1; ScrollMode:= false;
end;

procedure TFunctionListDialog.nShiftClick(Sender: TObject);
var
  s: string;
  Shift: TShiftState;
begin
  if ScrollMode then exit;
  if nShift.Checked then
  begin s:= 'Shift, '; Shift:= [ssShift]; end
  else begin s:= ''; Shift:= []; end;
  if nCtrl.Checked then begin s:= s+'Ctrl, '; Include(Shift,ssCtrl); end;
  if nAlt.Checked then begin s:= s+'Alt, '; Include(Shift,ssAlt); end;
  if s <> '' then
  begin SetLength(s,length(s)-2); s:= '['+s+']'; end;
  FunctionListGrid.Cells[0,FunctionListGrid.Row]:= s;
  FunctionList.Shift[FunctionListGrid.Row-1]:= Shift;
  OkBtn.Enabled:= true;
end;

function IndexToVKKey(Index: integer) : integer;
//8,9,13,32-40,45,48-57,65-90,91-93,12,106-107,109,111-135
begin
  case Index of
   0,1: inc(Index,8);
   2: Index:= 13;
   3..11: inc(Index,29);
   12: Index:= 45;
   13..22: inc(Index,35);
   23..51: inc(Index,42);
   52: Index:= 12;
   53,54: inc(Index,53);
   55: Index:= 109;
   56..80: inc(Index,55);
   else Index:= 0;
  end;
  IndexToVKKey:= Index;
end;

procedure TFunctionListDialog.nKeyChange(Sender: TObject);
begin
  if ScrollMode then exit;
  FunctionListGrid.Cells[1,FunctionListGrid.Row]:= nKey.Items[nKey.ItemIndex];
    FunctionList.Key[FunctionListGrid.Row-1]:= IndexToVKKey(nKey.ItemIndex);
  OkBtn.Enabled:= true;
end;

procedure TFunctionListDialog.nOprChange(Sender: TObject);
begin
  if ScrollMode then exit;
  FunctionListGrid.Cells[2,FunctionListGrid.Row]:= nOpr.Items[nOpr.ItemIndex];
  FunctionList.Operation[FunctionListGrid.Row-1]:= TOperation(nOpr.ItemIndex);
  OkBtn.Enabled:= true;
end;

procedure TFunctionListDialog.nValueChange(Sender: TObject);
begin
  if ScrollMode then exit;
  FunctionListGrid.Cells[3,FunctionListGrid.Row]:= nValue.Text;
  FunctionList.Value[FunctionListGrid.Row-1]:= nValue.Value;
  OkBtn.Enabled:= true;
end;

function TFunctionListDialog.CheckItem : boolean;
var
  s: string;
  i: integer;
  Res: boolean;
begin
  Res:= false;
  if nKey.ItemIndex = -1 then
  begin s:= 'Key code is not selected'; ActiveControl:= nKey; end
  else if nOpr.ItemIndex = -1 then
  begin s:= 'Operation is not selected'; ActiveControl:= nOpr; end
  else if nValue.Value = 0 then
  begin s:= 'Value must be other than 0.'; ActiveControl:= nValue; end
  else begin
    i:= 1;
    while (i < FunctionListGrid.RowCount) and ((i = FunctionListGrid.Row) or
      (FunctionListGrid.Cells[0,FunctionListGrid.Row] <> FunctionListGrid.Cells[0,i]) or
      (FunctionListGrid.Cells[1,FunctionListGrid.Row] <> FunctionListGrid.Cells[1,i])) do
        inc(i);
    if i < FunctionList.Count then s:= 'Key combination (shift+key) must be unique.'
    else Res:= true;
  end;
  if s <> '' then Application.MessageBox(pchar(s),'Error',mb_Ok+mb_IconStop);
  CheckItem:= Res;
end;

procedure TFunctionListDialog.NewBtnClick(Sender: TObject);
begin
  if FunctionListGrid.Visible then
    if CheckItem then
      with FunctionListGrid do
      begin
        RowCount:= RowCount+1; Row:= RowCount-1;
        ScrollMode:= true;
        nShift.Checked:= false; nCtrl.Checked:= false; nAlt.Checked:= false;
        nKey.ItemIndex:= -1; nOpr.ItemIndex:= -1; nValue.Value:= 0;
        ScrollMode:= false;
      end
    else
  else begin
    FunctionListGrid.Visible:= true; DelBtn.Enabled:= true;
    nShift.Enabled:= true; nCtrl.Enabled:= true; nAlt.Enabled:= true;
    nKey.Enabled:= true; nOpr.Enabled:= true; nValue.Enabled:= true;
  end;
  FunctionList.Add(MakeItem([],0,opAdd,0));
end;

procedure TFunctionListDialog.DelBtnClick(Sender: TObject);
var i: integer;
begin
  with FunctionListGrid do
  begin
    FunctionList.Delete(Row-1);
    for i:= Row to RowCount-1 do Rows[i]:= Rows[i+1];
    if RowCount > 2 then RowCount:= RowCount-1
    else begin
      for i:= 0 to 2 do Cells[i,1]:= ''; Cells[3,1]:= '0';
      nShift.Enabled:= false; nCtrl.Enabled:= false; nAlt.Enabled:= false;
      nKey.Enabled:= false; nOpr.Enabled:= false; nValue.Enabled:= false;
      Visible:= false; DelBtn.Enabled:= false;
    end;
    RefreshFromGrid(Row);
  end;
  OkBtn.Enabled:= true;
end;

procedure TFunctionListDialog.RefreshFromGrid(ARow: integer);
begin
  ScrollMode:= true;
  with FunctionListGrid do
  begin
    nShift.Checked:= pos('Shift',Cells[0,ARow]) <> 0;
    nCtrl.Checked:= pos('Ctrl',Cells[0,ARow]) <> 0;
    nAlt.Checked:= pos('Alt',Cells[0,ARow]) <> 0;
    nKey.ItemIndex:= nKey.Items.IndexOf(FunctionListGrid.Cells[1,ARow]);
    nOpr.ItemIndex:= nOpr.Items.IndexOf(FunctionListGrid.Cells[2,ARow]);
    nValue.Text:= FunctionListGrid.Cells[3,ARow];
  end;
  ScrollMode:= false;
end;

procedure TFunctionListDialog.FunctionListGridSelectCell(Sender: TObject;
  ACol, ARow: Integer; var CanSelect: Boolean);
begin
  CanSelect:= CheckItem;
  if CanSelect then RefreshFromGrid(ARow);
end;

procedure TFunctionListDialog.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if FunctionListGrid.Visible then CanClose:= CheckItem;
end;

end.

