unit EditsReg;

interface

uses
  Classes, DesignIntf, DesignEditors, AdvEdits;

type
  TFunctionListProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue : string; override;
  end;

procedure Register;

implementation
uses
  Windows, Forms, FuncListEditor;

function TFunctionListProperty.GetAttributes: TPropertyAttributes;
begin
  Result:= [paDialog, paReadOnly];
end;

procedure TFunctionListProperty.Edit;
var
  FunctionListDialog: TFunctionListDialog;
  fl: TAdvNumberEdit;
begin
  FunctionListDialog:= TFunctionListDialog.Create(Application);
  try
    fl:= GetComponent(0) as TAdvNumberEdit;
    FunctionListDialog.FunctionList.Assign(fl.FunctionList);
    if FunctionListDialog.ShowModal = idOk then
    begin
      fl.FunctionList.Assign(FunctionListDialog.FunctionList);
      Designer.Modified;
    end;
  finally
    FunctionListDialog.Free;
  end;
end;

function TFunctionListProperty.GetValue : string;
begin
  Result:= '(TFunctionList)';
end;


procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TFunctionList),TAdvNumberEdit,
    'FunctionList', TFunctionListProperty);
  RegisterComponents('AdvEdits', [TAdvFocusEdit,TAdvNumberEdit]);
end;

end.
